DROP PROCEDURE [hips].[ClinicalDocumentInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 7 March 2012
-- Description:   Inserts a new record into the PCEHR Table
-- 08/10/2012 - gmassey - changed Pcehr -> ClinicalDocument
-- 06/12/2012 - sbiber - Added status and removal information
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentInsert] 
(
	  @SourceSystemSetId varchar(128)
	, @EpisodeId INT
	, @DocumentTypeId INT
	, @RemovalReasonId INT
	, @RemovedDate DATETIME = NULL
	, @ClinicalDocumentStatusId INT
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @ClinicalDocumentId int

    SET @intErrorCode = 0


	INSERT INTO hips.ClinicalDocument
	(
		SourceSystemSetId,
		EpisodeId,
		DocumentTypeId,
		RemovalReasonId,
		RemovedDate,
		ClinicalDocumentStatusId,
		[DateCreated],
        [UserCreated],
        [DateModified],
        [UserModified]
		)
VALUES
	(
	@SourceSystemSetId
	, @EpisodeId
	, @DocumentTypeId
	, @RemovalReasonId
	, @RemovedDate
	, @ClinicalDocumentStatusId
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	 SELECT @intErrorCode = @@ERROR , @ClinicalDocumentId = SCOPE_IdENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [ClinicalDocumentId],
                SourceSystemSetId,
                EpisodeId,
                cd.DocumentTypeId,
				dt.Description as DocumentTypeDescription,
				dt.Code as DocumentTypeCode,
				cd.RemovalReasonId,
				rr.Description as RemovalReasonDescription,
				cd.RemovedDate,
				cd.ClinicalDocumentStatusId,
                cd.[DateCreated],
                cd.[UserCreated],
                cd.[DateModified],
                cd.[UserModified]
		FROM [hips].[ClinicalDocument] cd
		INNER JOIN hips.DocumentType As dt on dt.DocumentTypeId = cd.DocumentTypeId
		INNER JOIN hips.RemovalReason AS rr ON cd.RemovalReasonId = rr.RemovalReasonId
		WHERE [ClinicalDocumentId] = @ClinicalDocumentId
    END

    RETURN(@intErrorCode)

END
GO

